/**
  Copyright (c) 2012 Freescale Semiconductor
  
  \file       mc_doors.c
  \brief      This file contains the animations
  \author     Freescale Semiconductor
  \author     Automotive Systems Solutions Engineering
  \author     DB, r54930
  \version    1.0
  \date       16/Feb/2014
  
  * History:  16/Feb/2014- Initial Version

* Copyright (c) 2014, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
   
*/

#include "common.h"
#include "..\HIL\Graphics.h"
#include "..\HIL\Display.h"
#include "..\HIL\Flib.h"
#include "..\HAL\GALLO.h"
#include "..\SERVICES\DMAHandler.h"
#include "mc_parameters.h"
#include "FSLtime.h"
// Image objects
#include ".\Doors\full.h"
#include ".\Doors\boot.h"
#include ".\Doors\boot2.h"
#include ".\Doors\lflrc.h"
#include ".\Doors\lflro.h"
#include ".\Doors\lrlfc.h"
#include ".\Doors\lrlfo.h"
#include ".\Doors\rfrro.h"
#include ".\Doors\rfrrc.h"
#include ".\Doors\rrrfo.h"
#include ".\Doors\rrrfc.h"
#include ".\Doors\rdoors.h"
#include ".\Doors\gas.h"

/************/
/*  Defines */
/************/

#define DOOR_MC_Y_OFFSET        100
#define DOOR_MC_X_OFFSET        160
typedef struct{
  int8_t add;
  int8_t full;
  int8_t boot;
  int8_t gas;
  int8_t dfl;
  int8_t drl;
  int8_t dfr;
  int8_t drr;
}door_animationCounter_t;
/***********************************/
// ********  Constants  ************
/**********************************/

/********************/
/* Global Variables */
/********************/
mc_doors_parameters_t mc_doors_parameters;
static mc_doors_parameters_t mc_doors_parameters_l;  // lokal copy to keep track of state
uint8_t doors_position = 0;
/*********************************/
/* Function prototypes ***********/
/*********************************/
door_animationCounter_t aniCount ={0};
void doorsAnimateBoot(void);
void doorsAnimateLF(void);
void doorsAnimateLR(void);
void doorsAnimateFull(void);
void doorsAnimateRR(void);
void doorsAnimateRF(void);
void allClear(void);
void doorsAnimateGas(void);
void doorsAnimateRR2(void);
void doorsAnimateRF2(void);
/*******************************/
/*  Code starts Here           */
/*******************************/
void mc_doors(uint32_t CurrentFrame)
{
    uint32_t relative_fr;
    uint8_t dmachnl;
    
    if(mc_doors_properties.frameLatch == 0u)
    {
        mc_doors_properties.frameLatch = CurrentFrame;
    }
    relative_fr = CurrentFrame - mc_doors_properties.frameLatch;
    if (relative_fr % 2) return;  // an easy way to do 30fps instead of 60fps
    
// Init objects     
    switch(relative_fr)
    {
      case 0:
        allClear();
        aniCount.add = 0;
        aniCount.boot = 0;
        aniCount.dfl = 0;
        aniCount.drl = 0;
        aniCount.full = 0;
        aniCount.gas = 0;
        doors_position = 0;
        dmachnl = DMAHR_GetNextFreeChannel();
        Display_UpdateClutDMA(dmachnl, full_GObjectArray[0]);
        Display_InitLayer(DOORS_BASE,full_GObjectArray[0], 160, 137);
        DCU_LayerAlphaCfg(DOORS_BASE) = 0;
        DCU_LayerChromaCfg(DOORS_BASE) = 0;
        
        DCU_LayerAlphaCfg(DOORS_LEVEL1) = 0;
        DCU_LayerChromaCfg(DOORS_LEVEL1) = 0;
        
        DCU_LayerAlphaCfg(DOORS_LEVEL2) = 0;
        DCU_LayerChromaCfg(DOORS_LEVEL2) = 0;

        DCU_LayerAlphaCfg(DOORS_LEVEL3) = 0;
        DCU_LayerChromaCfg(DOORS_LEVEL3) = 0;
        
        DCU_LayerAlphaCfg(DOORS_LEVEL4) = 0;
        DCU_LayerChromaCfg(DOORS_LEVEL4) = 0;
        
        DCU_LayerAlphaCfg(DOORS_LEVEL5) = 0;
        DCU_LayerChromaCfg(DOORS_LEVEL5) = 0;
        
        DCU_LayerAlphaCfg(DOORS_LEVEL6) = 0;
        DCU_LayerChromaCfg(DOORS_LEVEL6) = 0;
        
        aniCount.add = 1;
     
        mc_doors_properties.autoDispose = 1; //supports AutoDispose
      break;
      default:
      break;
    }
    if (doors_position == 0){
      if ((mc_doors_parameters.doors.boot != mc_doors_parameters_l.doors.boot) || (aniCount.boot != 0))
      {
        doorsAnimateBoot();
      }
      else if ((mc_doors_parameters.doors.dfl != mc_doors_parameters_l.doors.dfl) || (aniCount.dfl != 0))
      {
        doorsAnimateLF();
      }
      else if ((mc_doors_parameters.doors.drl != mc_doors_parameters_l.doors.drl) || (aniCount.drl != 0))
      {
        doorsAnimateLR();
      }
      else if ((mc_doors_parameters.doors.dfr != mc_doors_parameters_l.doors.dfr) || (aniCount.dfr != 0))
      {
        doorsAnimateRF();
      }
      else if ((mc_doors_parameters.doors.drr != mc_doors_parameters_l.doors.drr) || (aniCount.drr != 0))
      {
        doorsAnimateRR();
      }
      else if (((mc_doors_parameters.doors.dfl == 0) && (mc_doors_parameters.doors.drl == 0)) &&
            (mc_doors_parameters.doors.dfr || mc_doors_parameters.doors.drr || mc_doors_parameters.doors.gas))
      {
        doors_position = 1;
        allClear();
      }          
    }
    else if (doors_position == 1){
      doorsAnimateFull();
    }
    else if (doors_position == 2){
      if ((mc_doors_parameters.doors.boot != mc_doors_parameters_l.doors.boot))
      {
        doorsAnimateBoot();
      }
      else if ((mc_doors_parameters.doors.dfr != mc_doors_parameters_l.doors.dfr))
      {
        doorsAnimateRF2();
        aniCount.drr = aniCount.dfr;
      }
      else if ((mc_doors_parameters.doors.drr != mc_doors_parameters_l.doors.drr))
      {
        doorsAnimateRR2();
        aniCount.dfr = aniCount.drr;
      }
      else if ((mc_doors_parameters.doors.gas != mc_doors_parameters_l.doors.gas))
      {
        doorsAnimateGas();
      }
      else if (mc_doors_parameters.doors.dfl || mc_doors_parameters.doors.drl)
      {
        doors_position = 3;
        allClear();
      }          
    }
    else if (doors_position == 3){
      doorsAnimateFull();
      //allClear();
    }
}
/********************************/
void doorsAnimateRF2(void){
  
  if ((mc_doors_parameters_l.doors.drr == 0) && (mc_doors_parameters_l.doors.dfr == 0)){
    if (aniCount.dfr == 0) aniCount.dfr = 39; 
    aniCount.dfr--;
    if (aniCount.dfr <= 29) mc_doors_parameters_l.doors.dfr = mc_doors_parameters.doors.dfr;
  }
  if ((mc_doors_parameters_l.doors.drr == 1) && (mc_doors_parameters_l.doors.dfr == 0)){
    aniCount.dfr++;
    if (aniCount.dfr >= 19) mc_doors_parameters_l.doors.dfr = mc_doors_parameters.doors.dfr;
  }
  if ((mc_doors_parameters_l.doors.drr == 1) && (mc_doors_parameters_l.doors.dfr == 1)){
    aniCount.dfr--;
    if (aniCount.dfr <= 10) mc_doors_parameters_l.doors.dfr = mc_doors_parameters.doors.dfr;
  }
  if ((mc_doors_parameters_l.doors.drr == 0) && (mc_doors_parameters_l.doors.dfr == 1)){
    aniCount.dfr++;
    if (aniCount.dfr >= 38) {
      mc_doors_parameters_l.doors.dfr = mc_doors_parameters.doors.dfr;
      aniCount.dfr = 0;
    }
  }
  if (aniCount.dfr)
    Display_InitLayer(DOORS_LEVEL2,rdoors_GObjectArray[aniCount.dfr], DOOR_MC_X_OFFSET + 255, DOOR_MC_Y_OFFSET + 100);
  else Display_LayerDisable(DOORS_LEVEL2);
}

/********************************/

/********************************/
void doorsAnimateRR2(void){
  
  if ((mc_doors_parameters_l.doors.drr == 0) && (mc_doors_parameters_l.doors.dfr == 0)){
    aniCount.drr++;
    if (aniCount.drr >= 9) mc_doors_parameters_l.doors.drr = mc_doors_parameters.doors.drr;
  }
  else if ((mc_doors_parameters_l.doors.drr == 1) && (mc_doors_parameters_l.doors.dfr == 0)){
    aniCount.drr--;
    if (aniCount.drr <= 0) mc_doors_parameters_l.doors.drr = mc_doors_parameters.doors.drr;
  }
  else if ((mc_doors_parameters_l.doors.drr == 1) && (mc_doors_parameters_l.doors.dfr == 1)){
    aniCount.drr++;
    if (aniCount.drr >= 29) mc_doors_parameters_l.doors.drr = mc_doors_parameters.doors.drr;
  }
  else if ((mc_doors_parameters_l.doors.drr == 0) && (mc_doors_parameters_l.doors.dfr == 1)){
    aniCount.drr--;
    if (aniCount.drr <= 19) mc_doors_parameters_l.doors.drr = mc_doors_parameters.doors.drr;
  }
  if (aniCount.drr)
    Display_InitLayer(DOORS_LEVEL2,rdoors_GObjectArray[aniCount.drr], DOOR_MC_X_OFFSET + 255, DOOR_MC_Y_OFFSET + 100);
  else 
      Display_LayerDisable(DOORS_LEVEL2);
  // Adjust the gas lid to correspond with the back door. 
  if (mc_doors_parameters_l.doors.gas)
  {
    if ((aniCount.drr >=0) && (aniCount.drr <=2) || (aniCount.drr >=28))
        Display_InitLayer(DOORS_LEVEL4,gas_GObjectArray[0], DOOR_MC_X_OFFSET + 190, DOOR_MC_Y_OFFSET + 158);
    else 
        Display_InitLayer(DOORS_LEVEL4,gas_GObjectArray[1], DOOR_MC_X_OFFSET + 190, DOOR_MC_Y_OFFSET + 158);
  }  

}
/********************************/
void doorsAnimateGas(void){
  if (mc_doors_parameters_l.doors.gas == 0){
    if (mc_doors_parameters_l.doors.drr)
      Display_InitLayer(DOORS_LEVEL4,gas_GObjectArray[1], DOOR_MC_X_OFFSET + 190, DOOR_MC_Y_OFFSET + 158);
    else 
      Display_InitLayer(DOORS_LEVEL4,gas_GObjectArray[0], DOOR_MC_X_OFFSET + 190, DOOR_MC_Y_OFFSET + 158);
  }
  else 
    Display_LayerDisable(DOORS_LEVEL4);
  
  mc_doors_parameters_l.doors.gas = mc_doors_parameters.doors.gas;
}

/********************************/
void allClear(void){
  aniCount.drr = 0;
  aniCount.dfr = 0;

  mc_doors_parameters_l.doors.boot = 0;
  mc_doors_parameters_l.doors.gas = 0;
  mc_doors_parameters_l.doors.dfl = 0;
  mc_doors_parameters_l.doors.dfr = 0;
  mc_doors_parameters_l.doors.drl = 0;
  mc_doors_parameters_l.doors.drr = 0;
  Display_LayerDisable(DOORS_LEVEL1);
  Display_LayerDisable(DOORS_LEVEL2);
  Display_LayerDisable(DOORS_LEVEL3);
  Display_LayerDisable(DOORS_LEVEL4);
  Display_LayerDisable(DOORS_LEVEL5);
  Display_LayerDisable(DOORS_LEVEL6);
}
/*********************************/
void doorsAnimateFull(void){

    aniCount.full += aniCount.add;
    Display_InitLayer(DOORS_BASE,full_GObjectArray[aniCount.full], 160, 137);
    if (aniCount.full >= 15){
      doors_position = 2;
      aniCount.add = -1;
    }
    else if (aniCount.full <= 0){
      doors_position = 0;
      aniCount.add = 1;
    }
}

/*************************************/
void doorsAnimateBoot(void)
{
  uint8_t done = 0;
  if (mc_doors_parameters_l.doors.boot == 0)
  {
    aniCount.boot++;
    if (aniCount.boot >= 8)done = 1;
  }
  else {
    if (aniCount.boot == 0) aniCount.boot = 8; //if we are closing we need a seed value that is the top position
    aniCount.boot--;
    if (aniCount.boot <= 0)done = 1;
  }
  if (doors_position)
    Display_InitLayer(DOORS_LEVEL1,boot2_GObjectArray[aniCount.boot], DOOR_MC_X_OFFSET + 0, DOOR_MC_Y_OFFSET + 18);
  else 
    Display_InitLayer(DOORS_LEVEL1,boot_GObjectArray[aniCount.boot], DOOR_MC_X_OFFSET + 258, DOOR_MC_Y_OFFSET + 8);
  if (done){
    aniCount.boot = 0;
    mc_doors_parameters_l.doors.boot = mc_doors_parameters.doors.boot;
    if (mc_doors_parameters_l.doors.boot == 0) Display_LayerDisable(DOORS_LEVEL1);
  }
}
/**************************************/
void doorsAnimateLF(void)
{
  uint8_t done = 0;
  if (mc_doors_parameters_l.doors.dfl == 0)
  {
    aniCount.dfl++;
    if (aniCount.dfl >= 8)done = 1;
  }
  else {
    if (aniCount.dfl == 0) aniCount.dfl = 8; //if we are closing we need a seed value that is the open position
    aniCount.dfl--;
    if (aniCount.dfl <= 0)done = 1;
  }
  if (done){
    if (mc_doors_parameters_l.doors.drl == 0){
        Display_InitLayer(DOORS_LEVEL2,lflrc_GObjectArray[aniCount.dfl], DOOR_MC_X_OFFSET + 243, DOOR_MC_Y_OFFSET + 100);
        //if (mc_doors_parameters_l.doors.drl)
          //Display_InitLayer(DOORS_LEVEL3,lrlfc_GObjectArray[8], DOOR_MC_X_OFFSET + 284, DOOR_MC_Y_OFFSET + 89);
    }
    else {
        Display_InitLayer(DOORS_LEVEL2,lflro_GObjectArray[aniCount.dfl], DOOR_MC_X_OFFSET + 243, DOOR_MC_Y_OFFSET + 100);
        if (mc_doors_parameters_l.doors.dfl)
          Display_InitLayer(DOORS_LEVEL3,lrlfc_GObjectArray[8], DOOR_MC_X_OFFSET + 284, DOOR_MC_Y_OFFSET + 89);
        else
          Display_InitLayer(DOORS_LEVEL3,lrlfo_GObjectArray[8], DOOR_MC_X_OFFSET + 284, DOOR_MC_Y_OFFSET + 89);
    }
    aniCount.dfl = 0;
    mc_doors_parameters_l.doors.dfl = mc_doors_parameters.doors.dfl;
    if (mc_doors_parameters_l.doors.dfl == 0) Display_LayerDisable(DOORS_LEVEL2);
    Display_LayerDisable(DOORS_LEVEL6);
  }
  else {
    if (mc_doors_parameters_l.doors.drl == 0)
        Display_InitLayer(DOORS_LEVEL6,lflrc_GObjectArray[aniCount.dfl], DOOR_MC_X_OFFSET + 243, DOOR_MC_Y_OFFSET + 100);
    else 
        Display_InitLayer(DOORS_LEVEL6,lflro_GObjectArray[aniCount.dfl], DOOR_MC_X_OFFSET + 243, DOOR_MC_Y_OFFSET + 100);
  } 
}
/**********************************************/
/**************************************/
void doorsAnimateLR(void)
{
  uint8_t done = 0;
  if (mc_doors_parameters_l.doors.drl == 0)
  {
    aniCount.drl++;
    if (aniCount.drl >= 8)done = 1;
  }
  else {
    if (aniCount.drl == 0) aniCount.drl = 8; //if we are closing we need a seed value that is the open position
    aniCount.drl--;
    if (aniCount.drl <= 0)done = 1;
  }
  if (done){
    if (mc_doors_parameters_l.doors.dfl == 0){
        Display_InitLayer(DOORS_LEVEL3,lrlfc_GObjectArray[aniCount.drl], DOOR_MC_X_OFFSET + 284, DOOR_MC_Y_OFFSET + 89);
        //if (mc_doors_parameters_l.doors.dfl)
          //Display_InitLayer(DOORS_LEVEL2,lflro_GObjectArray[0], DOOR_MC_X_OFFSET + 243, DOOR_MC_Y_OFFSET + 100);
    }  
    else{ 
        Display_InitLayer(DOORS_LEVEL3,lrlfo_GObjectArray[aniCount.drl], DOOR_MC_X_OFFSET + 284, DOOR_MC_Y_OFFSET + 89);
        if (mc_doors_parameters_l.doors.drl) 
          Display_InitLayer(DOORS_LEVEL2,lflrc_GObjectArray[8], DOOR_MC_X_OFFSET + 243, DOOR_MC_Y_OFFSET + 100);
        else 
          Display_InitLayer(DOORS_LEVEL2,lflro_GObjectArray[8], DOOR_MC_X_OFFSET + 243, DOOR_MC_Y_OFFSET + 100);
    }  
    aniCount.drl = 0;
    mc_doors_parameters_l.doors.drl = mc_doors_parameters.doors.drl;
    if (mc_doors_parameters_l.doors.drl == 0) Display_LayerDisable(DOORS_LEVEL3);
    Display_LayerDisable(DOORS_LEVEL6);
  }
  else {
    if (mc_doors_parameters_l.doors.dfl == 0)
        Display_InitLayer(DOORS_LEVEL6,lrlfc_GObjectArray[aniCount.drl], DOOR_MC_X_OFFSET + 284, DOOR_MC_Y_OFFSET + 89);
    else 
        Display_InitLayer(DOORS_LEVEL6,lrlfo_GObjectArray[aniCount.drl], DOOR_MC_X_OFFSET + 284, DOOR_MC_Y_OFFSET + 89);
  } 
}
/**********************************************/
/**************************************/
void doorsAnimateRF(void)
{
  uint8_t done = 0;
  if (mc_doors_parameters_l.doors.dfr == 0)
  {
    aniCount.dfr++;
    if (aniCount.dfr >= 8)done = 1;
  }
  else {
    if (aniCount.dfr == 0) aniCount.dfr = 9; //if we are closing we need a seed value that is the open position
    aniCount.dfr--;
    if (aniCount.dfr <= 0)done = 1;
  }
  if (done){
    if (mc_doors_parameters_l.doors.drr == 0){
        Display_InitLayer(DOORS_LEVEL5,rfrrc_GObjectArray[aniCount.dfr], DOOR_MC_X_OFFSET + 108, DOOR_MC_Y_OFFSET + 78);
    }  
    else{ 
        Display_InitLayer(DOORS_LEVEL5,rfrro_GObjectArray[aniCount.dfr], DOOR_MC_X_OFFSET + 108, DOOR_MC_Y_OFFSET + 78);
        if (mc_doors_parameters_l.doors.dfr) 
          Display_InitLayer(DOORS_LEVEL4,rrrfc_GObjectArray[9], DOOR_MC_X_OFFSET + 166, DOOR_MC_Y_OFFSET + 66);
        else 
          Display_InitLayer(DOORS_LEVEL4,rrrfo_GObjectArray[9], DOOR_MC_X_OFFSET + 166, DOOR_MC_Y_OFFSET + 66);
    }  
    aniCount.dfr = 0;
    mc_doors_parameters_l.doors.dfr = mc_doors_parameters.doors.dfr;
    if (mc_doors_parameters_l.doors.dfr == 0) Display_LayerDisable(DOORS_LEVEL5);
    Display_LayerDisable(DOORS_LEVEL6);
  }
  else {
    if (mc_doors_parameters_l.doors.drr == 0)
        Display_InitLayer(DOORS_LEVEL6,rfrrc_GObjectArray[aniCount.dfr], DOOR_MC_X_OFFSET + 108, DOOR_MC_Y_OFFSET + 78);
    else 
        Display_InitLayer(DOORS_LEVEL6,rfrro_GObjectArray[aniCount.dfr], DOOR_MC_X_OFFSET + 108, DOOR_MC_Y_OFFSET + 78);
  } 
}
/**********************************************/
/**************************************/
void doorsAnimateRR(void)
{
  uint8_t done = 0;
  if (mc_doors_parameters_l.doors.drr == 0)
  {
    aniCount.drr++;
    if (aniCount.drr >= 8)done = 1;
  }
  else {
    if (aniCount.drr == 0) aniCount.drr = 9; //if we are closing we need a seed value that is the open position
    aniCount.drr--;
    if (aniCount.drr <= 0)done = 1;
  }
  if (done){
    if (mc_doors_parameters_l.doors.dfr == 0){
        Display_InitLayer(DOORS_LEVEL4,rrrfc_GObjectArray[aniCount.drr], DOOR_MC_X_OFFSET + 166, DOOR_MC_Y_OFFSET + 66);
    }  
    else{ 
        Display_InitLayer(DOORS_LEVEL4,rrrfo_GObjectArray[aniCount.drr], DOOR_MC_X_OFFSET + 166, DOOR_MC_Y_OFFSET + 66);
        if (mc_doors_parameters_l.doors.drr)   
          Display_InitLayer(DOORS_LEVEL5,rfrrc_GObjectArray[9], DOOR_MC_X_OFFSET + 108, DOOR_MC_Y_OFFSET + 78);
        else 
          Display_InitLayer(DOORS_LEVEL5,rfrro_GObjectArray[9], DOOR_MC_X_OFFSET + 108, DOOR_MC_Y_OFFSET + 78);
    }  
    aniCount.drr = 0;
    mc_doors_parameters_l.doors.drr = mc_doors_parameters.doors.drr;
    if (mc_doors_parameters_l.doors.drr == 0) Display_LayerDisable(DOORS_LEVEL4);
    Display_LayerDisable(DOORS_LEVEL6);
  }
  else {
    if (mc_doors_parameters_l.doors.dfr == 0)
        Display_InitLayer(DOORS_LEVEL6,rrrfc_GObjectArray[aniCount.drr], DOOR_MC_X_OFFSET + 166, DOOR_MC_Y_OFFSET + 66);
    else 
        Display_InitLayer(DOORS_LEVEL6,rrrfo_GObjectArray[aniCount.drr], DOOR_MC_X_OFFSET + 166, DOOR_MC_Y_OFFSET + 66);
  } 
}
/**********************************************/
void mc_doors_Dispose()
{
  Display_LayerDisable(DOORS_BASE);
  Display_LayerDisable(DOORS_LEVEL1);
  Display_LayerDisable(DOORS_LEVEL2);
  Display_LayerDisable(DOORS_LEVEL3);
  Display_LayerDisable(DOORS_LEVEL4);
  Display_LayerDisable(DOORS_LEVEL5);
  Display_LayerDisable(DOORS_LEVEL6);
  
}

void mc_doors_Refresh()
{
  allClear();
}
